// Get all the section elements
const sections = document.querySelectorAll('.section');

// Create a new intersection observer
const observer = new IntersectionObserver((entries) => {
  // Loop through the entries
  for (const entry of entries) {
    // Get the section element
    const section = entry.target;

    // If the section is visible
    if (entry.intersectionRatio > 0) {
      // Add the active class to the section
      section.classList.add('active');
    } /* else {
      // Remove the active class from the section
      section.classList.remove('active');
    } */
  }
});

// Observe all the section elements
for (const section of sections) {
  observer.observe(section);
}

// Add a scroll event listener to the window
window.addEventListener('scroll', () => {
  // Loop through all the section elements
  for (const section of sections) {
    // Get the section's intersection ratio
    const intersectionRatio = section.intersectionRatio;

    // If the section is not visible and it was previously visible
    if (intersectionRatio < 0 && section.classList.contains('active')) {
      // Remove the active class from the section
      section.classList.remove('active');
    }
  }
});

function enviarCorreo() {
  const name = document.getElementById('name').value;
  const email = document.getElementById('email').value;
  const subject = document.getElementById('subject').value;
  const message = document.getElementById('message').value;

  // Validación básica de datos

  if (!name || !email || !subject || !message) {
    alert('Por favor, llena todos los campos del formulario.');
    return;
  }

  // Prepara los datos del formulario
  const data = new FormData();
  data.append('name', name);
  data.append('email', email);
  data.append('subject', subject);
  data.append('message', message);

  // Envia el formulario a un archivo PHP que procesará el envío del correo
  fetch('send_email.php', {
    method: 'POST',
    body: data,
  })
  .then(response => response.text())
  .then(data => {
    if (data === 'success') {
      alert('Tu mensaje ha sido enviado con éxito.');
    } else {
      alert('Ocurrió un error al enviar el mensaje. Inténtalo de nuevo más tarde.');
    }
  });
}

function toggleMenu() {
  var menu = document.getElementById("menu");
  menu.classList.toggle("show");
}